/**
 * Styleswitch stylesheet switcher built on jQuery
 * Under an Attribution, Share Alike License
 * By Kelvin Luck ( http://www.kelvinluck.com/ )
 **/

var $j = jQuery.noConflict();

function switchStyle(styleName) {
  if (styleName) {
    $j('body').removeClass();
    $j('#styleSwitch a').removeClass('selected');
    $j('#' + styleName).addClass('selected');
    $j('body').addClass(styleName);
  }
  createCookie('prettifystyleswitchcookie', styleName, 365);
}

$j(document).ready(function () {
  $j('#styleSwitch a#style1').addClass('selected');
  $j('#styleSwitch a').bind('click', function () {
    switchStyle(this.id);
    return false;
  });
  var c = readCookie('prettifystyleswitchcookie');
  if (c) switchStyle(c);
});

// cookie functions http://www.quirksmode.org/js/cookies.html
function createCookie(name, value, days) {
  if (days) {
    var date = new Date();
    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
    var expires = "; expires=" + date.toGMTString();
  } else var expires = "";
  document.cookie = name + "=" + value + expires + "; path=/";
}

function readCookie(name) {
  var nameEQ = name + "=";
  var ca = document.cookie.split(';');
  for (var i = 0; i < ca.length; i++) {
    var c = ca[i];
    while (c.charAt(0) == ' ') c = c.substring(1, c.length);
    if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
  }
  return null;
}

function eraseCookie(name) {
  createCookie(name, "", -1);
}
// /cookie functions
